<?php
include '../includes/header.php';
require_once '../config/database.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ./login.php');
    exit();
}

$database = new Database();
$db = $database->getConnection();

// Get notifications with pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 20;
$offset = ($page - 1) * $per_page;

$notifications_query = "SELECT n.*, u.email, u.first_name, u.last_name 
                       FROM email_notifications n 
                       JOIN users u ON n.user_id = u.id 
                       ORDER BY n.created_at DESC 
                       LIMIT $offset, $per_page";
$notifications = $db->query($notifications_query)->fetchAll(PDO::FETCH_ASSOC);

$total_notifications = $db->query("SELECT COUNT(*) FROM email_notifications")->fetchColumn();
$total_pages = ceil($total_notifications / $per_page);
?>

<div class="container py-5">
    <h2>Email Notifications</h2>
    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Type</th>
                            <th>Recipient</th>
                            <th>Subject</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th>Sent</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($notifications as $notification): ?>
                            <tr>
                                <td><?php echo ucfirst($notification['type']); ?></td>
                                <td>
                                    <?php echo $notification['first_name'] . ' ' . $notification['last_name']; ?><br>
                                    <small><?php echo $notification['email']; ?></small>
                                </td>
                                <td><?php echo $notification['subject']; ?></td>
                                <td>
                                    <span class="badge bg-<?php 
                                        echo $notification['status'] === 'sent' ? 'success' : 
                                            ($notification['status'] === 'pending' ? 'warning' : 'danger'); 
                                    ?>">
                                        <?php echo ucfirst($notification['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('M d, Y H:i', strtotime($notification['created_at'])); ?></td>
                                <td>
                                    <?php 
                                    echo $notification['sent_at'] 
                                        ? date('M d, Y H:i', strtotime($notification['sent_at'])) 
                                        : '-'; 
                                    ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <?php if ($total_pages > 1): ?>
                <nav aria-label="Page navigation" class="mt-4">
                    <ul class="pagination justify-content-center">
                        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                            <li class="page-item <?php echo $i === $page ? 'active' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                            </li>
                        <?php endfor; ?>
                    </ul>
                </nav>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?> 